﻿<# 
.SYNOPSIS 
Use Delprof2.exe to delete inactive profiles older than X days
tool from here: https://helgeklein.com/free-tools/delprof2-user-profile-deletion-tool
Permission was granted for Garytown.com to redistribute in content
.DESCRIPTION 
Gets Top Console user from ConfigMgr Client WMI, then runs delprof tool, excluding top console user list, 
and deletes any other inactive accounts based on how many days that you set in the -Days parameter.  
typical arugments;
        l   List only, do not delete (what-if mode) - Set by default
        u   Unattended (no confirmation) - Recommended to leave logs
        q   Quiet (no output and no confirmation)

.LINK
https://garytown.com
https://helgeklein.com/free-tools/delprof2-user-profile-deletion-tool - to see what arugments are available.

It should ONLY delete accounts that are XX_XXXXXXX (ef_u598896 for example)

#> 

Param(
  [string]$Days = '120',
  [string]$argument = 'l'
)
$PrimaryUser = (Get-WmiObject -Namespace "root\cimv2\sms"-class sms_SystemConsoleUser).SystemConsoleUser 
if ($PrimaryUser){$PrimaryUser = $PrimaryUser.split("\")[1]}
#Change the path of DelProf2.exe to where you have it.  In my package, I have it in a subfolder called StorageCleanUp
Write-Output ""
Write-Output "Version: 2021.01.05.01"
#Write-Output "Running Command Line: .\StorageCleanUp\DelProf2.exe /ed:$PrimaryUser /d:$days /id:??_* /$argument"
#.\StorageCleanUp\DelProf2.exe /ed:$PrimaryUser /d:$days /id:??_* /$argument


Write-Output "Running Command Line: .\StorageCleanUp\DelProf2.exe /ed:$PrimaryUser /id:TEMP* /$argument"
.\StorageCleanUp\DelProf2.exe /ed:$PrimaryUser /id:TEMP* /$argument

Write-Output "Running Command Line: .\StorageCleanUp\DelProf2.exe /ed:$PrimaryUser /id:defaultuser0* /$argument"
.\StorageCleanUp\DelProf2.exe /ed:$PrimaryUser /id:defaultuser0* /$argument


Write-Output "Complete Running Specific Profile Cleanup"
Write-Output ""